<?php
Yii::import("webroot.themes.press.ThemeFunctions");
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
$category_models = EpaperFeaturedCategory::model()->with("rEpaperCategory")->findAll(new CDbCriteria(array("order"=>"fcat_order ASC")));
if(!isset($featured_categories_perrow)){
    $featured_categories_perrow = 3;
}
if(!isset($featured_categories_thumbsize)){
	$featured_categories_thumbsize["width"] = 100;
	$featured_categories_thumbsize["height"] = 100;
}

if(count($category_models)>0) { ?>
        <section class="fcategorylist-block">
         <header class="title-header text-center">
                <h1 class="heading"><?php echo Press_ThemeSettings::i()->text_fcategory; ?></h1>
            </header>

        <div class="content">
            
        <?php
        $x = 1;
         
        foreach ($category_models as $model) {
            
            $model = $model->rEpaperCategory;
            $imageurl = $epaper_mediadir . $model->cat_image;
            if (trim($model->cat_image) == "") {
                $thumb = ImageHelpers::i()->getDefaultImage($featured_categories_thumbsize["width"], $featured_categories_thumbsize["height"], true);
            } else {
                $thumb = ImageHelpers::i()->getThumbImage($imageurl, $featured_categories_thumbsize["width"], $featured_categories_thumbsize["height"], true);
            }
            if ($x == 1) {
                echo "<div class='row'>";
            }
            ?>

            <div class="col-md-<?php echo 12/$featured_categories_perrow ?>">                 
                <div class="image">
                    <a class="thumbnail" href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->cat_id,"alias"=>$model->cat_alias)); ?>">
                        <img src="<?php echo $thumb; ?>" />
                    </a>
                </div>
                <div class="description">
                    <h4><?php echo CHtml::link(CHtml::encode($model->cat_title), $this->createUrl("//epaper/default/index", array("id" => $model->cat_id,"alias"=>$model->cat_alias))); ?></h4>
                    <p><?php echo CHtml::encode(Helpers::i()->wordLimiter($model->cat_desc, 17)); ?></p>
                </div>                
            </div>

            <?php
            if ($x == $featured_categories_perrow) {
                echo "</div>";
                $x = 1;
            } else {
                $x++;
            }
        }
        if ($x != 1) {
            echo "</div>";
        }
        ?>
        </div>
            
        </section>
<?php } ?>